//==============================================
//　調教ゲームオリジナルウィンドウ
// OriginalWindow.js
//=============================================

/*:ja
 * @plugindesc 調教ゲームメニュー表示プラグイン
 * @author TRS
 * 
 * @param -----共通の設定--------
 * @desc セパレータ
 * 
 * @param 文字サイズ
 * @desc 描画する文字のサイズ(12～96)
 * @type number
 * @max 96
 * @min 12
 * @default 24
 *
 * @param 出力内容の色
 * @desc 変数から出力される部分の文字色（RGB指定）
 * @default #FFFFFF
 *
 * @param ラインカラー
 * @desc 文字の下に引く線の色（RGB指定）
 * @default #FFFFFF
 *
 * @param -----ステータスの設定--------
 * @desc セパレータ
 *
 * @param 日付変数
 * @desc 日付数が入ってる変数ID
 * @type variable
 * @default 158
 *
 * @param 称号変数
 * @desc 称号の文字が入ってる変数ID
 * @type variable
 * @default 150
 * 
 * @param 親愛度
 * @desc 親愛度が入ってる変数ID
 * @type variable
 * @default 151
 *
 * @param 調教度
 * @desc 調教度が入ってる変数ID
 * @type variable
 * @default 152
 *
 * @param 胸の感じやすさ
 * @desc 胸の感じやすさが入ってる変数ID
 * @type variable
 * @default 153
 *
 * @param 膣の感じやすさ
 * @desc 膣の感じやすさが入ってる変数ID
 * @type variable
 * @default 154
 *
 * @param アナルの感じやすさ
 * @desc アナルの感じやすさが入ってる変数ID
 * @type variable
 * @default 155
 *
 * @param 初体験の相手
 * @desc 初体験の相手が入ってる変数ID
 * @type variable
 * @default 156
 *
 * @param H回数
 * @desc H回数が入ってる変数ID
 * @type variable
 * @default 157
 *
 * @param ---立ち絵の設定と気分----
 * @desc セパレータ
 *
 * @param 立ち絵
 * @desc 立ち絵ピクチャ
 * @type file[]
 * @require 1 
 * @dir img/pictures
 *
 * @param 立ち絵横座標
 * @desc ウィンドウ内の立ち絵の横座標設定(左端原点)
 * @type number
 * @max 816
 * @min -816 
 * @default 0
 *
 * @param 立ち絵縦座標
 * @desc ウィンドウ内の立ち絵の縦座標設定(上端原点)
 * @type number
 * @max 624
 * @min -624
 * @default 0
 *
 * @param 気分の文字種
 * @desc 気分の文字
 * @type string[]
 *
 * @param 今日の気分番号
 * @desc 今日の気分番号が入ってる変数ID
 * @type variable
 * @default 159
 *
 * @param ---吹き出しの設定----
 * @desc セパレータ
 *
 * @param 吹き出しピクチャ
 * @desc 吹き出しピクチャファイル
 * @type file
 * @require 1 
 * @dir img/pictures
 *
 * @param 吹き出しピクチャ横座標
 * @desc 吹き出しピクチャの横座標設定(左端原点)
 * @type number
 * @max 816
 * @min -816 
 * @default 0
 *
 * @param 吹き出しピクチャ縦座標
 * @desc ピクチャの縦座標設定(上端原点)
 * @type number
 * @max 624
 * @min -624
 * @default 0
 *
 * @param ---セーブボタンの設定----
 * @desc セパレータ
 *
 * @param セーブボタン画像
 * @desc セーブボタン画像ファイル
 * @type file
 * @require 1 
 * @dir img/pictures
 *
 * @param セーブボタン横座標
 * @desc セーブボタンピクチャの横座標
 * @type number 
 * @max 816
 * @min -816
 * @default 575
 *
 * @param セーブボタン縦座標
 * @desc セーブボタンピクチャの横座標
 * @type number 
 * @max 624
 * @min -624
 * @default 575
 *
 * @param ---戻るボタンの設定----
 * @desc セパレータ
 *
 * @param 戻るボタン画像
 * @desc 戻るボタン画像ファイル
 * @type file
 * @require 1 
 * @dir img/pictures
 *
 * @param 戻るボタン横座標
 * @desc 戻るボタンピクチャの横座標
 * @type number 
 * @max 816
 * @min -816
 * @default 700
 *
 * @param 戻るボタン縦座標
 * @desc 戻るボタンピクチャの横座標
 * @type number 
 * @max 624
 * @min -624
 * @default 575
 *
 * @help
 * 調教ゲーム用のステータス画面表示スクリプト
 */
(function()
{
	var parameters = PluginManager.parameters('OriginalWindow');
	var params = [];
	
	//共通設定
	params.fontSize = Number( parameters['文字サイズ'] || 24 );
	params.outTextColor = parameters['出力内容の色'] || '#ffffff';	
	params.lineColor = parameters['ラインカラー'] || '#ffffff';
	
	//変数の設定
	params.syogoValId = Number( parameters['称号変数'] || 150 );
	params.shinAiValId = Number (parameters['親愛度'] || 151 );
	params.chokyoValId = Number (parameters['調教度'] || 152 );
	params.bustFeelValId = Number (parameters['胸の感じやすさ'] || 153 );
	params.vaginaFeelValId = Number (parameters['膣の感じやすさ'] || 154 );
	params.analFeelValId = Number (parameters['アナルの感じやすさ'] || 155 );
	params.firstExperienceValId = Number (parameters['初体験の相手'] || 156 );
	params.hCntValId = Number (parameters['H回数'] || 157 );
	params.dayInfo = Number( parameters['日付変数'] || 158 );
	
	//立ち絵の設定とその日の気分
	//params.standPicName = String( parameters['立ち絵'] );
	params.lstStandPicName = JSON.parse(parameters['立ち絵'] || '[]');
	params.standPicXpos = Number( parameters['立ち絵横座標'] || 0 );
	params.standPicYpos = Number( parameters['立ち絵縦座標'] || 0 );
	
	params.lstFeel = JSON.parse(parameters['気分の文字種'] || '[]');
	params.biorhythmValId = Number (parameters['今日の気分番号'] || 159 );
	
	
	//吹き出しの設定
	params.fukidashiPicName = String( parameters['吹き出しピクチャ'] );
	params.fukidashiXpos = Number( parameters['吹き出しピクチャ横座標'] || 0 );
	params.fukidashiYpos = Number( parameters['吹き出しピクチャ縦座標'] || 0 );
	
	//セーブボタンの設定
	params.saveBtnPicname = String( parameters['セーブボタン画像'] );
	params.saveBtnXpos = Number( parameters['セーブボタン横座標'] || 575 );
	params.saveBtnYpos = Number( parameters['セーブボタン縦座標'] || 575 );
	
	//戻るボタンの設定
	params.returnBtnPicname = String( parameters['戻るボタン画像'] );
	params.returnBtnXpos = Number( parameters['戻るボタン横座標'] || 700 );
	params.returnBtnYpos = Number( parameters['戻るボタン縦座標'] || 575 );
	
	var btnClickInfo = [];
	btnClickInfo.saveWidth = 0;								//セーブボタン幅
	btnClickInfo.saveHeight = 0;							//セーブボタン高さ
	btnClickInfo.returnWidth = 0;							//戻るボタン幅
	btnClickInfo.returnHeight = 0;							//戻るボタン高さ
	
	// Open Menu Screen
	Game_Interpreter.prototype.command351 = function() {
	    if (!$gameParty.inBattle()) 
	    {
	    	SceneManager.push(Scene_OriginalWindow);
	        //SceneManager.push(Scene_Menu);				//このあたりを変える必要あり
	        //Window_MenuCommand.initCommandPosition();	//このあたりを変える必要あり
	    }
	    return true;
	};
	
	//クリックとかでメニュー呼ばれた
	Scene_Map.prototype.callMenu = function() 
	{
	    SoundManager.playOk();
	    //SceneManager.push(Scene_Menu);
	    SceneManager.push(Scene_OriginalWindow);
	    Window_MenuCommand.initCommandPosition();
	    $gameTemp.clearDestination();
	    this._mapNameWindow.hide();
	    this._waitCount = 2;
	};

	/**
	 * 追加出来るコマンドのアタッチ
	*/
	Window_MenuCommand.prototype.addOriginalCommands = function () 
    {
    	 this.addCommand("テストステ", 'nantoka');
    };
    
	Scene_Menu.prototype.createCommandWindow = function () 
	{
        this._commandWindow = new Window_MenuCommand(0, 0);
        this._commandWindow.setHandler('item', this.commandItem.bind(this));
        this._commandWindow.setHandler('skill', this.commandPersonal.bind(this));
        this._commandWindow.setHandler('equip', this.commandPersonal.bind(this));
        this._commandWindow.setHandler('status', this.commandPersonal.bind(this));
        this._commandWindow.setHandler('formation', this.commandFormation.bind(this));
        this._commandWindow.setHandler('options', this.commandOptions.bind(this));
        this._commandWindow.setHandler('save', this.commandSave.bind(this));
        this._commandWindow.setHandler('gameEnd', this.commandGameEnd.bind(this));
        this._commandWindow.setHandler('cancel', this.popScene.bind(this));
        this._commandWindow.setHandler('nantoka', this.commandCyokyoWin.bind(this));				//メニューに追加
        
        this.addWindow(this._commandWindow);
	};
	
	Scene_Menu.prototype.commandCyokyoWin = function() {
		SceneManager.push(Scene_OriginalWindow);												//調教ゲーパラメーターウィンドウ
	};
	
	//-------------------------------------------------------------------------------------------
	// 何とか回数呼び出しクラス(とりあえず今ウィンドウのみ出してみる)（SCEN）
	
	/*
	*　コンストラクタ
	*/
	function Scene_OriginalWindow()
	{
		 this.initialize.apply(this, arguments);
	}
	
	Scene_OriginalWindow.prototype =  Object.create(Scene_MenuBase.prototype);
	Scene_OriginalWindow.prototype.constructor = Scene_OriginalWindow;
	
	/**
	 *　初期化
	 */
	Scene_OriginalWindow.prototype.initialize = function() 
	{
    	Scene_MenuBase.prototype.initialize.call(this);	
	};
	
	/**
	*　作成処理
	*/
	Scene_OriginalWindow.prototype.create = function() 
	{
		Scene_MenuBase.prototype.create.call(this);
		this.createOriginalWindow();
	
	};
	
	/**
	 *　何とかウィンドウ描画
	 */
	Scene_OriginalWindow.prototype.createOriginalWindow = function() 
	{
	    this._originalWindow = new Window_OriginalWindow();
	    this._originalWindow.setHandler('cancel', this.popScene.bind(this));
	    this.addWindow(this._originalWindow);
	};
	
	/**
	 *背景描画
	 */
	Scene_OriginalWindow.prototype.createBackground = function() 
	{
	    Scene_MenuBase.prototype.createBackground.call(this);
	    this.setBackgroundOpacity(128);
    };

	
	//------------------------------------------------------------------
	// 調教ゲームステータスウィンドウ作成クラス

	/**
	 *　調教ゲームステータスウィンドウメイン
	 */
	function Window_OriginalWindow() 
	{
    	this.initialize.apply(this, arguments);
	}

	Window_OriginalWindow.prototype = Object.create(Window_Selectable.prototype);
	Window_OriginalWindow.prototype.constructor = Window_OriginalWindow;

	Window_OriginalWindow.prototype.initialize = function(x, y) {
	    var width = Graphics.boxWidth;
	    var height =  Graphics.boxHeight;
	    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
	    this._fixOutPos = 2 * params.fontSize;									//出力テキストの座標設定
	    
	    this.refresh();
	    this.activate();				//これを入れないとXのキャンセルが効かない
	    
	};
	
	/**
	 * リフレッシュ
	 */
	Window_OriginalWindow.prototype.refresh = function() 
	{
		
		this.contents.clear();
		
		var varIndex = $gameVariables.value( params.biorhythmValId );
		
		//範囲外の時は最初のを入れる
		if( varIndex >= params.lstStandPicName.length || varIndex < 0 )
		{
			varIndex = 0;
		}
		
		this.drawPicture(params.lstStandPicName[ varIndex ], params.standPicXpos, params.standPicYpos);					//バストアップピクチャ描画
		this.drawPicture(params.fukidashiPicName, params.fukidashiXpos, params.fukidashiYpos);				//吹き出しピクチャ1描画
		
		//this.drawSaveBtn( params.saveBtnPicname, params.saveBtnXpos, params.saveBtnYpos );
		this.drawReturnBtn( params.returnBtnPicname, params.returnBtnXpos, params.returnBtnYpos );
		
		this.totalDraw();
		
	};
	
	/**
	* 常時描画（なにかアニメーションやりたいときはこれを使うといいかも）
	*/
	Window_OriginalWindow.prototype.update = function() 
	{
		Window_Selectable.prototype.update.call(this);
	//	this.bustUpDraw();
	//	//this.SeiekiDraw();
		
		this.ButtonPushChkProcess();					//ボタン押下確認処理
		
		this.refresh();
	};

	/**
	 *　イラスト描画
	 */
	
	Window_OriginalWindow.prototype.drawPicture = function(picName, xPos, yPos)
	{
		var bitmap;
		
		bitmap = ImageManager.loadPicture(picName);		//ウィンドウに描画するピクチャ描画
		
		var OffsetX = xPos;
		var OffsetY = yPos;
		
		//sx 開始X座標(ピクチャの描画を開始するX座標(-はNG) 基本的に0でいいかも)
		//sy 開始Y座標(ピクチャの描画を開始するY座標(-はNG) 基本的に0でいいかも)
		//Sw 幅？(描画範囲W)
		//Sh 高さ?（描画範囲h）
		//dx ずらすX座標
		//dy ずらすY座標
		
		//var sw = 816;
		//var sh = 624;
		//var dx = 0;
		//var dy = 0 + 624;
		//var sx = bitmap.width / 2 - 816 / 2 - OffsetX;
		//var sy = OffsetY;
		
		this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, OffsetX, OffsetY);
	};
	
	/**
	 * セーブボタン描画
	 */
	Window_OriginalWindow.prototype.drawSaveBtn = function()
	{
		//セーブできない時は消す
		if( $gameSystem.isSaveEnabled() === false)
			return;

		var bitmap;
		
		bitmap = ImageManager.loadPicture( params.saveBtnPicname );		//ウィンドウに描画するピクチャ描画
		
		var OffsetX = params.saveBtnXpos;
		var OffsetY = params.saveBtnYpos;
		
		btnClickInfo.saveWidth = bitmap.width;								//セーブボタン幅記憶
		btnClickInfo.saveHeight = bitmap.height;							//セーブボタン高さ記憶
	
		this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, OffsetX, OffsetY);
	};
	
	/**
	 * 戻るボタン描画
	 */
	Window_OriginalWindow.prototype.drawReturnBtn = function()
	{
		var bitmap;
		
		bitmap = ImageManager.loadPicture( params.returnBtnPicname );		//ウィンドウに描画するピクチャ描画
		
		var OffsetX = params.returnBtnXpos;
		var OffsetY = params.returnBtnYpos;
		
		btnClickInfo.returnWidth = bitmap.width;							//戻るボタン幅記憶
		btnClickInfo.returnHeight = bitmap.height;							//戻るボタン高さ記憶
	
		this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, OffsetX, OffsetY);
	};
	
	
	Window_OriginalWindow.prototype.standardPadding = function() 
	{
    	return 0;
	};

	/**
	 *メニュー文字の全描画
	 */
	Window_OriginalWindow.prototype.totalDraw = function()
	{
		
		this.drawDay();
		this.drawGold();
		
		this.drawShogo();																					//称号描画
		this.drawSinai();																					//親愛度描画
		this.drawChokyo();																					//調教度
		this.drawBustFeel();																				//胸の感じやすさ
		this.drawVaginaFeel();																				//膣の感じやすさ
		this.drawAnalFeel();																				//アナルの感じやすさ
		this.drawFirstExperience();																			//初体験の相手
		this.drawHcnt();																					//H回数
		
		this.drawDayFeeling();																				//今日の気分
	}
	
	/**
	 * 日付描画
	 */
	Window_OriginalWindow.prototype.drawDay = function()
	{
		var varLinePos1 = 15;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//日付文字描画
		var lblFont = "日付";					//日付文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.dayInfo );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) ) + '日目', this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 所持金描画
	 */
	Window_OriginalWindow.prototype.drawGold = function()
	{
		var varLinePos1 = 60;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//所持金描画
		var lblFont = "所持金";					//所持金描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = String( $gameParty._gold );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( txtFont ) + '円', this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 称号文字描画
	 */
	Window_OriginalWindow.prototype.drawShogo = function()
	{
		this.contents.fontSize = params.fontSize;
		//称号文字描画
		var lblFont = "称号";					//称号文字描画
		this.drawText( lblFont, 10, 150, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.syogoValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( txtFont, this._fixOutPos, 150, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, 150 + params.fontSize + 5, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 親愛度描画
	 */
	Window_OriginalWindow.prototype.drawSinai = function()
	{
		var varLinePos1 = (170 + params.fontSize * 1) + 10 * 1;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//親愛度文字描画
		var lblFont = "親愛度";					//親愛度文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.shinAiValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) ), this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 調教度描画
	 */
	Window_OriginalWindow.prototype.drawChokyo = function()
	{
		var varLinePos1 = (170 + params.fontSize * 2) + 10 * 2;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//調教度文字描画
		var lblFont = "調教度";					//調教度文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.chokyoValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) ), this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 胸の感じやすさ描画
	 */
	Window_OriginalWindow.prototype.drawBustFeel = function()
	{
		var varLinePos1 = (170 + params.fontSize * 3) + 10 * 3;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//胸の感じやすさ
		var lblFont = "胸の感じやすさ";					//胸の感じやすさ文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.bustFeelValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) + "％" ), this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 膣の感じやすさ描画
	 */
	Window_OriginalWindow.prototype.drawVaginaFeel = function()
	{
		var varLinePos1 = (170 + params.fontSize * 4) + 10 * 4;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//膣の感じやすさ
		var lblFont = "膣の感じやすさ";					//膣の感じやすさ文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.vaginaFeelValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) + "％" ), this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * アナルの感じやすさ描画
	 */
	Window_OriginalWindow.prototype.drawAnalFeel = function()
	{
		var varLinePos1 = (170 + params.fontSize * 5) + 10 * 5;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//アナルの感じやすさ
		var lblFont = "アナルの感じやすさ";					//アナルの感じやすさ文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.analFeelValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) + "％" ), this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 初体験の相手描画
	 */
	Window_OriginalWindow.prototype.drawFirstExperience = function()
	{
		this.contents.fontSize = params.fontSize;
		//称号文字描画
		var lblFont = "初体験の相手";					//初体験の相手文字描画
		this.drawText( lblFont, 10, 510, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = "";
		if( $gameVariables.value( params.firstExperienceValId ) !== 0)
		{
			txtFont = $gameVariables.value( params.firstExperienceValId );
		}
		else
		{
			txtFont = "処女";
		}
		
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( txtFont, this._fixOutPos, 510, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, 150 + params.fontSize + 5, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * H回数描画
	 */
	Window_OriginalWindow.prototype.drawHcnt = function()
	{
		var varLinePos1 = 575;
		var varLinePos2 = varLinePos1 + params.fontSize + 5;
		
		this.contents.fontSize = params.fontSize;
		//親愛度文字描画
		var lblFont = "Ｈ回数";					//親愛度文字描画
		this.drawText( lblFont, 10, varLinePos1, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = $gameVariables.value( params.hCntValId );
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );								//指定された色へ変更
		this.drawText( hankakuToZenkaku( String( txtFont ) ) + "回", this._fixOutPos, varLinePos1, 270, 'right');
		this.changeTextColor( this.normalColor() );									//元の色へ変更
		//this.drawHorzLine(0, varLinePos2, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * 今日の気分文字描画
	 */
	Window_OriginalWindow.prototype.drawDayFeeling = function()
	{
		var varIndex = $gameVariables.value( params.biorhythmValId );
		this.contents.fontSize = params.fontSize;
		//称号文字描画
		var lblFont = "今日の気分";					//称号文字描画
		this.drawText( lblFont, 635, 15, (lblFont.length + 5) * this.contents.fontSize);
		
		//テキストフォント
		var txtFont = "";
		
		//範囲内
		if( varIndex < params.lstFeel.length && varIndex >= 0 )
			txtFont = params.lstFeel[varIndex] + "気分";
			
		//範囲外(ミス入力対応)
		else
			txtFont = "？？？";
		
		var varFontWidth = txtFont.length * params.fontSize;
		this.changeTextColor( params.outTextColor );									//指定された色へ変更
		this.drawText( txtFont, 560, 15 + this.contents.fontSize + 5, 266, 'center');
		this.changeTextColor( this.normalColor() );										//元の色へ変更
		//this.drawHorzLine(0, 150 + params.fontSize + 5, 320, 3, params.lineColor);	//線描画
	}
	
	/**
	 * セパレータ線の描画
	 */
	Window_OriginalWindow.prototype.drawHorzLine = function(x, y, width, height, color) 
	{
	    this.contents.paintOpacity = 255;					//変更時はここに数値を入れる
	    this.contents.fillRect(x, y, width, height, color);
	    this.contents.paintOpacity = 255;
  	};
  	
  	/**
  	 * ボタン押下とりまとめチェック
  	 */
  	Window_OriginalWindow.prototype.ButtonPushChkProcess = function()
  	{
  		var saveInput = this.ButtonPushChk(params.saveBtnXpos, params.saveBtnYpos, btnClickInfo.saveWidth, btnClickInfo.saveHeight);	//セーブボタン
  		var returnInput = this.ButtonPushChk(params.returnBtnXpos, params.returnBtnYpos, btnClickInfo.returnWidth, btnClickInfo.returnHeight);	//戻るボタン
  		
  		//セーブ画面へ
  		//if( saveInput )
  		//{
  			//セーブできない時はパス
		//	if( $gameSystem.isSaveEnabled() === false)
		//		return;
			
		//	SoundManager.playOk();
  		//	SceneManager.push( Scene_Save );
  		//}
  		
  		//前の画面へ
  		if(returnInput)
  		{
			SoundManager.playCancel();
  			SceneManager.pop();
  			
  		}
  	}
  	
  	/**
  	 * ボタン入力確認
  	 */
  	Window_OriginalWindow.prototype.ButtonPushChk = function( btnXpos, btnYpos, btnWidth, btnHeight )
  	{
  		var varRet = false;
  		
  		//マウスボタン押された時
		if( TouchInput.isTriggered() )
		{
			if( ( TouchInput.x < btnXpos + btnWidth && TouchInput.x > btnXpos) && 
			    ( TouchInput.y < btnYpos + btnHeight && TouchInput.y > btnYpos) )
					varRet = true; 
		}
		
  		return varRet
  	}
  	
  	function hankakuToZenkaku(str) 
  	{
    	return str.replace(/[A-Za-z0-9]/g, function(s) {
        	return String.fromCharCode(s.charCodeAt(0) + 0xFEE0);
    	});
	}
	
})();
